local pn = ...;
assert(pn);

local t = Def.ActorFrame{};

local IsUsingSoloSingles = PREFSMAN:GetPreference('Center1Player');
local NumPlayers = GAMESTATE:GetNumPlayersEnabled();
local NumSides = GAMESTATE:GetNumSidesJoined();

local function GetPosition(pn)
	if IsUsingSoloSingles and NumPlayers == 1 and NumSides == 1 then return SCREEN_CENTER_X; end;

	local strPlayer = (NumPlayers == 1) and "OnePlayer" or "TwoPlayers";
	local strSide = (NumSides == 1) and "OneSide" or "TwoSides";
	return THEME:GetMetric("ScreenGameplay","Player".. pname(pn) .. strPlayer .. strSide .."X");
end;

t[#t+1] = AutoText("frutiger")..{
	Text="Full Combo!";
	InitCommand=cmd(shadowlength,0;diffuse,PlayerColor(pn);strokecolor,PlayerDarkColor(pn);draworder,98);
	BeginCommand=function(self)
		self:diffusealpha(0);
		self:x( GetPosition(pn) );
		-- xxx: designed for normal scroll (aka not reverse)
		self:y(SCREEN_CENTER_Y*1.35);
	end;
	AnimCommand=cmd(accelerate,0.25;diffusealpha,1;glow,color("1,1,1,0.75");zoom,1.5;decelerate,0.75;glow,color("1,1,1,0");zoom,1;sleep,2;decelerate,0.2;diffusealpha,0);
	OffCommand=function(self)
		local stats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
		local bFullCombo = false;
		local dq = stats:IsDisqualified()
		local failed = stats:GetFailed()
		local tnsComboThreshold = THEME:GetMetric("Gameplay","MinScoreToContinueCombo");
		bFullCombo = stats:FullComboOfScore(tnsComboThreshold)

		if bFullCombo and not failed and not dq then
			-- check player modifiers
			if GAMESTATE:PlayerIsUsingModifier(pn,"little") then
				return
			end

			self:queuecommand("Anim")
		end;
	end;
};

return t;